%% VeParticle.cls

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{VeParticle_RISS}[2023/03/24 Vita e Pensiero LateX class for RISS journal - ver 2.0]

\ExecuteOptions{10.5pt}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\LoadClass[twoside]{article}

\RequirePackage{graphics,graphicx,epstopdf,amsthm,amsfonts,amsmath,pifont,needspace,csquotes,appendix}

\RequirePackage{fontspec}
\setmainfont{Times New Roman}

\RequirePackage{anyfontsize}


\RequirePackage[comma,authoryear,sort]{natbib}
\bibpunct{(}{)}{;}{a}{,}{,} % required for natbib
\setlength{\bibhang}{0pt}
\renewcommand{\bibsection}{
    \newpage{}
	\vskip 6mm
	\fontsize{9.5}{11}\selectfont
	\begin{center} REFERENCES\end{center}
}

\RequirePackage[textfont={it},justification=centering,singlelinecheck=true,position=top,skip=5pt]{caption}


\DeclareCaptionLabelSeparator{dotDash}{. - }
\DeclareCaptionFormat{RISSformat}{\fontsize{10.5}{12}\selectfont#1#2#3}
\captionsetup{labelsep=dotDash,format=RISSformat}

\RequirePackage{fancyhdr}
\pagestyle{fancy}

\newtheoremstyle{theosty}%
  {3mm}% measure of space to leave above the theorem. E.g.: 3pt
  {3mm}% measure of space to leave below the theorem. E.g.: 3pt
  {\slshape}% name of font to use in the body of the theorem
  {0pt}% measure of space to indent
  {\scshape}% name of head font
  { }% punctuation between head and body
  {0mm}% space after theorem head
  {}% Manually specify head
\theoremstyle{theosty}

\newtheorem{theorem}{Theorem}
\newtheorem{proposition}[theorem]{Proposition}
\newtheorem{remark}[theorem]{Remark}
\newtheorem{lemma}[theorem]{Lemma}
\newtheorem{corollary}[theorem]{Corollary}
\newtheorem{definition}[theorem]{Definition}
\newtheorem{assumption}[theorem]{Assumption}
\newtheorem{example}{Example}

\renewcommand{\footnotesize}{\fontsize{9}{10}\selectfont}

\RequirePackage[symbol*]{footmisc}
\setlength\footnotemargin{20pt}
\setfnsymbol{wiley}
\RequirePackage{marvosym}

\renewcommand{\thefootnote}{\fnsymbol{footnote}}

\def\s@brunningtitle{\relax} 
\def\runningtitle#1{\gdef\s@brunningtitle{#1}}

\def\s@brunningauthors{\relax} 
\def\runningauthors#1{\gdef\s@brunningauthors{#1}}

\fancyhead{}
\fancyfoot{}
\fancyhead[OC]{\scriptsize\MakeUppercase{\s@brunningtitle}}
\fancyhead[EL,OR]{\small\thepage}
\fancyhead[EC]{\scriptsize\MakeUppercase{\s@brunningauthors}}
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}

\fancypagestyle{first}{
\fancyhf{} 
\fancyhead[OR]{\fontsize{9}{10}\selectfont Rivista Internazionale di Scienze Sociali, YYYY, n. x, pxx-pxx\\\fontsize{8}{9}\selectfont Published online xxxx}
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}}

\def\s@btitle{\relax} 
\def\subtitle#1{\gdef\s@btitle{#1}} 

\def\s@bthanks{\relax} 
\def\thanks#1{\gdef\s@bthanks{#1}} 

\def\s@bauthors{\relax} 
\def\authors#1{\gdef\s@bauthors{#1}}

\newcommand{\authorblock}{
	\vskip 4mm
	\s@bauthors\vskip 1mm}

\newcommand{\affiliat}[1]{\footnote{#1}}
\newcommand{\corresp}[1]{\Letter\hspace{0.2em}}

\let\svthefootnote\thefootnote
\newcommand\freefootnote[1]{%
  \let\thefootnote\relax%
  \setlength\footnotesep{5mm}
  \footnotetext{#1}%
  \let\thefootnote\svthefootnote%
}

\renewcommand{\maketitle}{
	\thispagestyle{first}
	\begin{center}
		\MakeUppercase{\@title}
		\if\s@btitle\relax 
                	\else\typeout{[subtitle]}
                         \par\MakeUppercase{\s@btitle}
                	\fi 
		\if\s@bauthors\relax 
                	\else\authorblock
	                \fi
		\if\s@bthanks\relax 
                	\else\typeout{[thanks]}
                         \freefootnote{\s@bthanks}
                	\fi			                
	\end{center}
	\vskip 4mm
	\setcounter{footnote}{0}
	\renewcommand{\thefootnote}{\arabic{footnote}}
}

\renewcommand{\abstract}[1]{
	\vskip 6mm
	\begin{flushright}\fontsize{8.5}{8}\selectfont ABSTRACT\end{flushright}
	\vskip -2mm \noindent {\it\fontsize{9}{11}\selectfont#1}
}

\newcommand{\keywords}[1]{
	\vskip 4mm
	\noindent {\fontsize{9}{11}\selectfont{\textit{Keywords}}: {\fontsize{9}{11}\selectfont#1}.}
}

\newcommand{\JEL}[1]{
	\noindent {\fontsize{9}{11}\selectfont{\textit{JEL Classification}}: {\fontsize{9}{11}\selectfont#1}.}
}

\newcommand{\ISSN}[1]{
	\noindent {\fontsize{9}{11}\selectfont{\textit{ISSN}}: {\fontsize{9}{11}\selectfont 0035-676X (print); 1827-7918 (digital)#1}}
}

\newcommand{\DOI}[1]{
	\noindent {\fontsize{9}{11}\selectfont{\textit{DOI}}: {\fontsize{9}{11}\selectfont 10.26350\slash000518\_#1}}
}


\renewcommand{\@seccntformat}[1]{
\ifnum\value{subsection}=0
   \csname the#1\endcsname.\hskip0.25em
\else
   \hskip-0.25em\csname the#1\endcsname\hskip0.25em
\fi
}

\renewcommand\section{\@startsection{section}{1}{\z@}%
                                   {-10mm \@plus 0ex \@minus 0ex}%
                                   {2mm \@plus0ex}%
                                   {\flushright\fontsize{8.5}{10}\selectfont\MakeUppercase}}
                                   
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                   {-10mm \@plus 0ex \@minus 0ex}%
                                   {2mm \@plus2ex}%
                                   {\fontsize{10.5}{12}\selectfont\itshape}}
                                     
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                   {-10mm \@plus 0ex \@minus 0ex}%
                                   {2mm \@plus2ex}%
                                   {\fontsize{10.5}{12}\selectfont}}


\renewcommand{\appendix}{
    \newpage{}
	\fontsize{10.5}{12}\selectfont
	\begin{center}\fontsize{9.5}{11}\selectfont APPENDIX\end{center}
	\renewcommand{\thefigure}{A\arabic{figure}}
	\setcounter{figure}{0}
	\renewcommand{\theequation}{A\arabic{equation}}
	\setcounter{equation}{0}
	\renewcommand{\thetable}{A\arabic{table}}
	\setcounter{table}{0}
	\setcounter{section}{0}
	\renewcommand\thesection{A\arabic{section}}
}


\RequirePackage{ctable}

\def\tablename{\fontsize{8.5}{10}\selectfont\MakeUppercase{Table}}
\def\figurename{\fontsize{8.5}{10}\selectfont\MakeUppercase{Figure}}





