%% VeParticle.cls

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{VeParticle_RISS}[2011/09/15 Vita e Pensiero LateX class for RISS journal - ver 1.0]

\ExecuteOptions{10.5pt}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\LoadClass[leqno, twoside]{article}

\RequirePackage{graphics,graphicx,epstopdf,amsthm,amsfonts,amsmath,pifont,needspace}

\RequirePackage[comma,authoryear,sort]{natbib}
\bibpunct{(}{)}{;}{a}{,}{,} % required for natbib
\renewcommand{\bibsection}{
	\vskip 6mm
	\begin{center}\footnotesize REFERENCES\end{center}
}

\RequirePackage[labelfont={sc},textfont={it},justification==raggedright,singlelinecheck=true,position=top]{caption}


\DeclareCaptionLabelSeparator{dotDash}{. -- }
\captionsetup{labelsep=dotDash}

\RequirePackage{fancyhdr}
\pagestyle{fancy}

\renewcommand{\tablename}{Table}
\renewcommand{\figurename}{Figure}



\newtheoremstyle{theosty}%
  {3mm}% measure of space to leave above the theorem. E.g.: 3pt
  {3mm}% measure of space to leave below the theorem. E.g.: 3pt
  {\slshape}% name of font to use in the body of the theorem
  {0pt}% measure of space to indent
  {\scshape}% name of head font
  { }% punctuation between head and body
  {0mm}% space after theorem head
  {}% Manually specify head
\theoremstyle{theosty}

\newtheorem{theorem}{Theorem}
\newtheorem{proposition}[theorem]{Proposition}
\newtheorem{remark}[theorem]{Remark}
\newtheorem{lemma}[theorem]{Lemma}
\newtheorem{corollary}[theorem]{Corollary}
\newtheorem{definition}[theorem]{Definition}
\newtheorem{assumption}[theorem]{Assumption}
\newtheorem{example}{Example}



\renewcommand{\thefootnote}{\fnsymbol{footnote}}

\def\s@brunningtitle{\relax} 
\def\runningtitle#1{\gdef\s@brunningtitle{#1}}

\def\s@brunningauthors{\relax} 
\def\runningauthors#1{\gdef\s@brunningauthors{#1}}

\fancyhead{}
\fancyfoot{}
\fancyhead[OC]{\scriptsize\MakeUppercase{\s@brunningtitle}}
\fancyhead[EL,OR]{\small\thepage}
\fancyhead[EC]{\scriptsize\MakeUppercase{\s@brunningauthors}}
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}

\fancypagestyle{first}{
\fancyhf{} 
\fancyhead[OR]{\footnotesize Rivista Internazionale di Scienze Sociali, YYYY, n. x, pxx-pxx}
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}}

\def\s@btitle{\relax} 
\def\subtitle#1{\gdef\s@btitle{#1}} 

\def\s@bthanks{\relax} 
\def\thanks#1{\gdef\s@bthanks{#1}} 

\def\s@bauthors{\relax} 
\def\authors#1{\gdef\s@bauthors{#1}}

\def\s@bcorrespondingauthor{\relax} 
\def\correspondingauthor#1{\gdef\s@correspondingauthor{#1}}

\def\s@baffiliations{\relax}
\def\affiliations#1{\gdef\s@baffiliations{#1}} 

\newcommand{\authorblock}{
	\vskip 4mm
	\s@bauthors\footnotetext{\vskip 1mm\noindent{\large\ding{41}} \s@correspondingauthor \vskip 1mm\vskip 1mm\noindent\s@baffiliations\vskip 1mm}
}


\renewcommand{\maketitle}{
	\thispagestyle{first}
	\begin{center}
		\MakeUppercase{\@title}
		\if\s@btitle\relax 
                	\else\typeout{[subtitle]}
                         \par\MakeUppercase{\s@btitle}
                	\fi 
	
		\if\s@bthanks\relax 
                	\else\typeout{[thanks]}
                         \footnotetext{\vskip 0mm\noindent\s@bthanks}
                	\fi
	
		\authorblock
		
	\end{center}
	\vskip 4mm
	\setcounter{footnote}{0}
	\renewcommand{\thefootnote}{\arabic{footnote}}
}

\renewcommand{\thefootnote}{\fnsymbol{footnote}}

\renewcommand{\abstract}[1]{
	\vskip 3mm
	\begin{flushright}\footnotesize ABSTRACT\end{flushright}
	\par
	{\small#1}
}

\newcommand{\keywords}[1]{
	\vskip 4mm
	\noindent {\small{\textit{Keywords}}: {\small#1}}
}

\newcommand{\JEL}[1]{
	\noindent {\footnotesize{\textit{JEL Classification}}: {\small#1}}
}

\newcounter{sectionCount}
\setcounter{sectionCount}{0}
\renewcommand{\section}[1]{
	\needspace{3em}
	\addtocounter{sectionCount}{1}
	\vskip 6mm
	\begin{flushright}
	\textsc{\footnotesize{\arabic{sectionCount}. #1}}
	\end{flushright}
	\par
}

\newcounter{sectionSubCount}
\setcounter{sectionSubCount}{0}
\renewcommand{\subsection}[1]{
	\needspace{3em}
	\addtocounter{sectionSubCount}{1}
	\vskip 5mm
	\noindent{\arabic{sectionCount}.\arabic{sectionSubCount}.} \textit{#1}
	\vskip 2mm
	\par
}

\newcounter{sectionSubSubCount}
\setcounter{sectionSubSubCount}{0}
\renewcommand{\subsubsection}[1]{
	\needspace{3em}
	\addtocounter{sectionSubSubCount}{1}
	\vskip 5mm
	\noindent{\arabic{sectionCount}.\arabic{sectionSubCount}.\arabic{sectionSubSubCount}.} \textit{#1}
	\vskip 2mm
	\par
}

\renewenvironment{quotation}[1]{\vskip 2mm\setlength{\parindent}{0in}\small{#1}}{\vskip 2mm}
\renewenvironment{quote}[1]{\vskip 2mm\setlength{\parindent}{0in}\small{#1}}{\vskip 2mm}

\RequirePackage{ctable}
